;
;								EJEMPLO 11
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;El Display de 7 segmentos
;
;Sobre el display de ctodo comn conectado a la puerta B, se desea visualiza el estado
;lgico "0" o "1" del interruptor RA0. Mediante el interruptor RA1 se activa o no el 
;punto decimal.
	
			List	p=16F876A		;Tipo de procesador
			include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;proteccin de cdig y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC
                
				org	0x00			;Vector de RESET
				goto	Inicio
				org	0x05

Inicio	       	clrf 	PORTB		;Borra los latch de salida
				bsf		STATUS,RP0	;Selecciona banco 1
				clrf	TRISB		;Puerta B se configura como salida
				movlw	0x06
				movwf	ADCON1		;Puerta A digital
				movlw	b'00111111'		
				movwf	TRISA		;Puerta A se configura como entrada		
				bcf		STATUS,RP0	;Selecciona banco 0			                                                                         

Loop			btfsc	PORTA,0		;Chequea RA0
				goto	RA0_es_1	;Es nivel "1"
				movlw	b'00111111'
				movwf	PORTB		;Visualiza el dgito 0 mediante su 
									;correspondiente cdigo de 7 segmentos
				goto 	Test_RA1
RA0_es_1		movlw	b'00000110'
				movwf	PORTB		;Visualiza el dgito 1 mediante su 
									;correspondiente cdigo de 7 segmentos
Test_RA1		btfsc	PORTA,1		;Chequea RA1
				goto	RA1_es_1	;Est a "1"
				bcf		PORTB,7		;Desconecta punto decimal
				goto	Loop
RA1_es_1:		bsf		PORTB,7		;Activa punto decimal
				goto	Loop

				end					;Fin del programa fuente
